/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.routes;

import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.routes.IVWConditionParameterSource;
import filenet.vw.toolkit.design.property.routes.VWFieldPanel;
import filenet.vw.toolkit.design.property.routes.VWResponsePanel;
import javax.swing.JTabbedPane;

class VWRouteTabbedPane
extends JTabbedPane
implements IVWConditionParameterSource {
    private VWFieldPanel m_fieldPanel = null;
    private VWResponsePanel m_responsePanel = null;

    public VWRouteTabbedPane(VWAuthPropertyData authPropertyData) {
        try {
            this.setTabPlacement(1);
            this.m_responsePanel = new VWResponsePanel(authPropertyData);
            this.add(VWResource.s_responsesStr, this.m_responsePanel);
            this.m_fieldPanel = new VWFieldPanel(authPropertyData);
            this.add(VWResource.s_fieldsStr, this.m_fieldPanel);
            this.setSelectedIndex(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setEnabled(boolean b) {
        this.m_fieldPanel.setEnabled(b);
        this.m_responsePanel.setEnabled(b);
        super.setEnabled(b);
    }

    public String getConditionString() {
        IVWConditionParameterSource source = null;
        source = (IVWConditionParameterSource)((Object)this.getSelectedComponent());
        if (source != null) {
            return source.getConditionString();
        }
        return null;
    }

    protected void setSelectedRoute(VWRouteDefinition routeDefinition) {
        if (this.m_responsePanel != null) {
            this.m_responsePanel.setSelectedRoute(routeDefinition);
        }
    }

    protected void releaseReferences() {
        if (this.m_fieldPanel != null) {
            this.m_fieldPanel.releaseReferences();
            this.m_fieldPanel = null;
        }
        if (this.m_responsePanel != null) {
            this.m_responsePanel.releaseReferences();
            this.m_responsePanel = null;
        }
    }
}

